/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.common.collect.ImmutableList;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7923;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.json.JsonCondition;
import slimeknights.tconstruct.library.json.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.modifiers.spilling.effects.ConditionalSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.DamageSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.SetFireSpillingEffect;

public abstract class AbstractSpillingFluidProvider
extends GenericDataProvider {
    private final String modId;
    private final Map<class_2960, Builder> entries = new HashMap<class_2960, Builder>();

    public AbstractSpillingFluidProvider(FabricDataOutput output, String modId) {
        super(output, class_3264.field_14190, "tinkering/spilling", SpillingFluidManager.GSON);
        this.modId = modId;
    }

    protected abstract void addFluids();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.addFluids();
        ArrayList futures = new ArrayList();
        this.entries.forEach((id, data) -> futures.add(this.saveThing(cache, (class_2960)id, data.build())));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected Builder addFluid(class_2960 id, FluidIngredient fluid) {
        Builder newBuilder = new Builder(fluid);
        Builder original = this.entries.put(id, newBuilder);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate spilling fluid " + String.valueOf(id));
        }
        return newBuilder;
    }

    protected Builder addFluid(String name, FluidIngredient fluid) {
        return this.addFluid(new class_2960(this.modId, name), fluid);
    }

    protected Builder addFluid(FluidStack fluid) {
        return this.addFluid(Objects.requireNonNull(class_7923.field_41173.method_10221((Object)fluid.getFluid())).method_12832(), FluidIngredient.of((FluidStack)fluid));
    }

    protected Builder addFluid(class_3611 fluid, long amount) {
        return this.addFluid(Objects.requireNonNull(class_7923.field_41173.method_10221((Object)fluid)).method_12832(), FluidIngredient.of((class_3611)fluid, (long)amount));
    }

    protected Builder addFluid(String name, class_6862<class_3611> fluid, long amount) {
        return this.addFluid(name, FluidIngredient.of(fluid, (long)amount));
    }

    protected Builder addFluid(class_6862<class_3611> fluid, long amount) {
        return this.addFluid(fluid.comp_327().method_12832(), fluid, amount);
    }

    protected Builder addFluid(FluidObject<?> fluid, boolean forgeTag, long amount) {
        return this.addFluid((class_6862<class_3611>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), amount);
    }

    protected Builder burningFluid(class_6862<class_3611> tag, float damage, int time) {
        return this.burningFluid(tag.comp_327().method_12832(), tag, 1000L, damage, time);
    }

    protected Builder burningFluid(String name, class_6862<class_3611> tag, long amount, float damage, int time) {
        Builder builder = this.addFluid(name, tag, amount).addEffect(LivingEntityPredicate.FIRE_IMMUNE.inverted(), new DamageSpillingEffect(DamageSpillingEffect.DamageType.FIRE, damage));
        if (time > 0) {
            builder.addEffect(new SetFireSpillingEffect(time));
        }
        return builder;
    }

    protected static class Builder {
        private ConditionJsonProvider condition = null;
        private final FluidIngredient ingredient;
        private final ImmutableList.Builder<ISpillingEffect> effects = ImmutableList.builder();

        public Builder addEffect(ISpillingEffect effect) {
            this.effects.add((Object)effect);
            return this;
        }

        public Builder addEffect(IJsonPredicate<class_1309> predicate, ISpillingEffect effect) {
            return this.addEffect(new ConditionalSpillingEffect(predicate, effect));
        }

        private SpillingFluidJson build() {
            ImmutableList effects = this.effects.build();
            if (effects.isEmpty()) {
                throw new IllegalStateException("Must have at least 1 effect");
            }
            return new SpillingFluidJson(new JsonCondition(this.condition), this.ingredient, (List<ISpillingEffect>)effects);
        }

        public Builder(FluidIngredient ingredient) {
            this.ingredient = ingredient;
        }

        public Builder condition(ConditionJsonProvider condition) {
            this.condition = condition;
            return this;
        }
    }

    private static class SpillingFluidJson {
        private final JsonCondition condition;
        private final FluidIngredient fluid;
        private final List<ISpillingEffect> effects;

        public SpillingFluidJson(JsonCondition condition, FluidIngredient fluid, List<ISpillingEffect> effects) {
            this.condition = condition;
            this.fluid = fluid;
            this.effects = effects;
        }
    }
}

